﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class Student_Competence : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.Student_Competence, BO.Student_Competence>
    {

        internal Student_Competence(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal Student_Competence(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.Student_Competence.DBD) { }

        internal bool Remove(BO.Student_Competence.Search Search)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student_Competence.Commands.RemoveBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }

        internal List<BO.Student_Competence> Restore(BO.Student_Competence.Search Search)
        {
            return InternalRestoreList((int)DBD.Student_Competence.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
            });
        }

        internal BO.Student_Competence RestoreTopOne(BO.Student_Competence.Search Search)
        {
            return InternalRestoreOne((int)DBD.Student_Competence.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
            });
        }

        internal int Count(BO.Student_Competence.Search Search)
        {
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student_Competence.Commands.CountBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["StudentID"].Value = Search.StudentID;
                    Command["CompetenceID"].Value = Search.CompetenceID;
                });

            if (_command != null)
            {
                return Convert.ToInt32(_command["Result"].Value);
            }
            return 0;
        }
    }
}
